from bpy.types import PropertyGroup
from bpy.props import PointerProperty
from .props_list_fluid_groups import FluidGroupList
from .props_list_fluid_interactions import FluidInteractionsList
from .props_list_fluid_mesh import FluidMeshList
from .props_list_fluid_colliders import FluidCollidersList
from .props_list_fluid_single_colliders import FluidSingleCollidersList
from .props_list_fluid_forces_group import FluidForcesGroupsList


class AllLists(PropertyGroup):

    """ context.scene.fluidlab.lists """

    # Fluid Groups List:
    fluid_groups: PointerProperty(type=FluidGroupList)

    # Fluid Interactions List:
    fluid_interactions: PointerProperty(type=FluidInteractionsList)

    # Fluid Mesh List:
    fluid_mesh: PointerProperty(type=FluidMeshList)

    # Fluid Collides:
    fluid_colliders: PointerProperty(type=FluidCollidersList)

    # Fluid SINGLE Collides:
    fluid_single_colliders: PointerProperty(type=FluidSingleCollidersList)

    # Fluid Forces Groups:
    fluid_forces_groups: PointerProperty(type=FluidForcesGroupsList)
